/*
 * 	DCM.c
 *
 *  Created on: Aug 23, 2010
 *  Author: Jared Rought
 *
 *  Function: Provides the directional cosine matrix for self-stabilization calculations.
 */

#include "DCM.h"
#include "stm32f10x.h"

#define T .02
#define KPXY 256*10
#define KIXY 256*2
#define KPZ 0.5
#define KIZ 0.0005

void PILoop(float* OmegaP, float* OmegaI, float* ErrorXY, float* ErrorZ);
void matrixMult(float MatOut[3][3], float Mat1[3][3], float Mat2[3][3]);
void matrixAdd(float MatOut[3][3], float Mat1[3][3], float Mat2[3][3]);
void vectorCross(float* CrossOut, float* v1, float* v2);
float vectorDot(float* v1, float* v2);
void vectorAdd(float* vOut, float* v1, float* v2);
void vectorScale(float* vOut, float* vIn, float ScaleFactor);

//Global DCM Variables
float Gyros[3] = {0, 0, 0};
float Accels[3] = {0, 0, 0};
float Mag[3] = {0,0,0};
float Omega[3] = {0, 0, 0};
float OmegaI[3] = {0, 0, 0};
float OmegaP[3] = {0, 0, 0};
float ErrorXY[3] = {0,0,0};
float ErrorZ[3] = {0,0,0};
float ErrorXYScaled[3] = {0,0,0};


float DCMt;
float roll;
float RmatUpdated[3][3];
float RmatTemp[3][3];

float Xorthog[3] = {0, 0, 0};
float Yorthog[3] = {0, 0, 0};
float Zorthog[3] = {0, 0, 0};
float error;
float normalized;

float OmegaITemp[3] = {0,0,0};

float MatTemp[3];



//This function updates the rotational matrix based on the measured gyro values,
//Then subsequently normalizes the matrix to compensate for accumulated numerical
//integration errors.
void updateRmat(void){
	//local variables

	 // Update gyros vector and apply signs
	Gyros[0] = -GyroCon[0]; // x gyro
	Gyros[1] = -GyroCon[1]; // y gyro
	Gyros[2] = -GyroCon[2]; // z gyro
	Accels[0] = -AccCon[0]; // x accel
	Accels[1] = -AccCon[1]; // y accel
	Accels[2] = -AccCon[2]; // z accel
	Mag[0] = -MagCon[0];
	Mag[1] = -MagCon[1];
	Mag[2] = -MagCon[2];

	// Add proportional and integral terms
	vectorAdd(&Omega[0], &Gyros[0], &OmegaI[0]);
	vectorAdd(&Omega[0], &Omega[0], &OmegaP[0]);

	RmatUpdated[0][0] = 0;
	RmatUpdated[0][1] = -Omega[2]*T;  //z
	RmatUpdated[0][2] = Omega[1]*T; //-y
	RmatUpdated[1][0] = Omega[2]*T; //-z
	RmatUpdated[1][1] = 0;
	RmatUpdated[1][2] = -Omega[0]*T; //x
	RmatUpdated[2][0] = -Omega[1]*T; //y
	RmatUpdated[2][1] = Omega[0]*T;//-x
	RmatUpdated[2][2] = 0;

	matrixMult(&RmatTemp[0], &Rmat[0], &RmatUpdated[0]);
	matrixAdd(&Rmat[0], &Rmat[0], &RmatTemp[0]);

	normRmat();
	DCMt = Rmat[2][0];
	roll = Rmat[2][1];
}

//DCM normalizing function
void normRmat(void){

						//X vector  //Y vector
	error = -vectorDot(&Rmat[0][0], &Rmat[1][0])*0.5; //error scaling factor

	//X orthogonal vector
	vectorScale(&Xorthog[0], &Rmat[1][0], error);
	vectorAdd(&Xorthog[0], &Xorthog[0], &Rmat[0][0]);

	//Y orthogonal vector
	vectorScale(&Yorthog[0], &Rmat[0][0], error);
	vectorAdd(&Yorthog[0], &Yorthog[0], &Rmat[1][0]);

	//Z orthogonal vector
	vectorCross(&Zorthog[0], &Xorthog[0], &Yorthog[0]);

	//Taylor's Expansion
	//X normalized
	normalized = 0.5*(3-vectorDot(&Xorthog[0], &Xorthog[0]));
	vectorScale(&Rmat[0][0], &Xorthog[0], normalized);

	//Y normalized
	normalized = 0.5*(3-vectorDot(&Yorthog[0], &Yorthog[0]));
	vectorScale(&Rmat[1][0], &Yorthog[0], normalized);

	//Z normalized
	normalized = 0.5*(3-vectorDot(&Zorthog[0], &Zorthog[0]));
	vectorScale(&Rmat[2][0], &Zorthog[0], normalized);
}

//Gyro drift compensation function. This function compensates for pitch, roll and yaw drift
void correctRmat(void){
	float Magnitude,COGX,COGY,YawCorrectionGround,YawCorrectionPlane;


	Magnitude = sqrtf(Mag[0]*Mag[0] + Mag[1]*Mag[1] + Mag[2]*Mag[2]);
	//Roll and Pitch Correction
	vectorCross(&ErrorXY[0], &Accels[0], &Rmat[2][0]);

	//Yaw Correction
	//Magnetometer heading calculation
	COGX = cosf(COGtheta);
	COGY = sinf(COGtheta);

	YawCorrectionGround = Rmat[0][0]*COGX - Rmat[1][0]*COGY;
	//vectorScale(YawCorrectionPlane, Rmat[2], YawCorrectionGround);


}

//PI loop function for utilizing the error that was calculated by the drift compensation function
void PILoop(float* OmegaP, float* OmegaI, float* ErrorXY, float* ErrorZ) {


	vectorScale(&OmegaP[0], &ErrorXY[0], KPXY);
	vectorScale(&OmegaITemp[0], &ErrorXY[0], KIXY);
	vectorAdd(&OmegaI[0], &OmegaI[0], &OmegaITemp[0]);


	vectorScale(OmegaP, ErrorZ, KPZ);
	vectorScale(ErrorXYScaled, ErrorXY, KPXY);
	vectorAdd(OmegaP, OmegaP, ErrorXYScaled);

	vectorScale(OmegaITemp, ErrorZ, KIZ);
	vectorScale(ErrorXYScaled, ErrorXY, KIXY);
	vectorAdd(OmegaI, OmegaI, ErrorXYScaled);

	vectorAdd(OmegaI, OmegaI, OmegaITemp);
}

//DCM arithmatic

//Matrix operations
void matrixMult(float MatOut[][3], float Mat1[][3], float Mat2[][3]){


	for(i=0;i<3;i++){
		for(j=0;j<3;j++){
			for(k=0;k<3;k++){
				MatTemp[k] = Mat1[i][k]*Mat2[k][j];
			}
			MatOut[i][j] = MatTemp[0] + MatTemp[1]+ MatTemp[2];
		}
	}
}

void matrixAdd(float MatOut[][3], float Mat1[][3], float Mat2[][3]){


	for(i=0;i<3;i++){
		for(j=0;j<3;j++){
			MatOut[i][j] = Mat1[i][j] + Mat2[i][j];
		}
	}
}

void vectorCross(float* CrossOut, float* v1, float* v2){
	CrossOut[0] = (v1[1]*v2[2]) - (v1[2]*v2[1]);
	CrossOut[1] = (v1[2]*v2[0]) - (v1[0]*v2[2]);
	CrossOut[2] = (v1[0]*v2[1]) - (v1[1]*v2[0]);
}

//Vector Operations
float vectorDot(float* v1, float* v2){
	float dot = 0;


	for(i=0;i<3;i++){
		dot += v1[i]*v2[i];
	}return dot;
}

void vectorAdd(float* vOut, float* v1, float* v2){


	for(i=0;i<3;i++){
		vOut[i] = v1[i] + v2[i];
	}
}

void vectorScale(float* vOut, float* vIn, float ScaleFactor){


	for(i=0;i<3;i++){
		vOut[i] = vIn[i]*ScaleFactor;
	}
}
